function dy = ode_system(t,y,k)
% Reaccin enzimtica mediante mecanismo Michaelis

%Renombracin para facilitar la lectura
S  = y(1);
E  = y(2);
ES = y(3);
P  = y(4);

%Planteamos el sistema
dS  = -k(1)*S*E + k(2)*ES;
dE  = -k(1)*S*E + k(2)*ES + k(3)*ES;
dES =  k(1)*S*E - k(2)*ES - k(3)*ES;
dP  =  k(3)*ES;

dy = [dS dE dES dP]';
